/**************************************************************************************
 Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: CcLinkIeSlave_ErrorCodes.h 73856 2018-01-26 13:46:59Z Sven $:


Changes:
 Date          Description
 -----------------------------------------------------------------------------------
 yyyy-mm-dd    created
**************************************************************************************/

#ifndef CCLINKIESLAVE_ERRORCODES_H_INCLUDED
#define CCLINKIESLAVE_ERRORCODES_H_INCLUDED

#ifndef CCLIES_ERROR_TABLE_BEGIN
#define CCLIES_ERROR_TABLE_BEGIN typedef enum CCLIES_ERROR_CODE_Etag {
#endif

#ifndef CCLIES_ERROR_RESULT
#define CCLIES_ERROR_RESULT(x, v) x = v,
#endif

#ifndef CCLIES_ERROR_TABLE_END
#define CCLIES_ERROR_TABLE_END CCLIES_ERROR_CODE_VALUE_RANGE = 0xFFFFFFFF } CCLIES_ERROR_CODE_E;
#endif

CCLIES_ERROR_TABLE_BEGIN
#ifndef CCLIES_ERROR_TABLE_EXCLUDE_COMMON_ERRORS
CCLIES_ERROR_RESULT(CCLIES_SUCCESS, 0)

CCLIES_ERROR_RESULT(CCLIES_ERROR_FAIL, 0xC0000001)
CCLIES_ERROR_RESULT(CCLIES_ERROR_UNEXPECTED, 0xC0000002)
CCLIES_ERROR_RESULT(CCLIES_ERROR_OUT_OF_MEMORY, 0xC0000003)
CCLIES_ERROR_RESULT(CCLIES_ERROR_UNKNOWN_COMMAND, 0xC0000004)
CCLIES_ERROR_RESULT(CCLIES_ERROR_INVALID_PARAMETER, 0xC0000009)
CCLIES_ERROR_RESULT(CCLIES_ERROR_WATCHDOG_TIMEOUT, 0xC000000C)
CCLIES_ERROR_RESULT(CCLIES_ERROR_INVALID_SEQUENCE, 0xC000000F)
CCLIES_ERROR_RESULT(CCLIES_ERROR_REQUEST_RUNNING, 0xC000001A)
CCLIES_ERROR_RESULT(CCLIES_ERROR_NOT_CONFIGURED, 0xC0000119)
CCLIES_ERROR_RESULT(CCLIES_ERROR_CONFIGURATION_FAULT, 0xC0000120)
CCLIES_ERROR_RESULT(CCLIES_ERROR_INSUFFICIENT_LICENSE, 0xC0000123)
CCLIES_ERROR_RESULT(CCLIES_ERROR_PARAMETER_ERROR, 0xC0000124)
CCLIES_ERROR_RESULT(CCLIES_ERROR_NETWORK_FAULT, 0xC0000140)
CCLIES_ERROR_RESULT(CCLIES_ERROR_CONNECTION_TIMEOUT, 0xC0000142)
CCLIES_ERROR_RESULT(CCLIES_ERROR_CABLE_DISCONNECT, 0xC0000145)
CCLIES_ERROR_RESULT(CCLIES_ERROR_BUS_OFF, 0xC0000180)
CCLIES_ERROR_RESULT(CCLIES_ERROR_CONFIG_IS_LOCKED, 0xC0000181)
CCLIES_ERROR_RESULT(CCLIES_ERROR_APPLICATION_ALREADY_REGISTERED, 0xC0000201)
CCLIES_ERROR_RESULT(CCLIES_ERROR_NO_APPLICATION_REGISTERED, 0xC0000202)
#endif

/* HIL_COMPONENT_ID_CCLIES                =  0xF3:HIL_COMPONENT_ID_CCLIES */
CCLIES_ERROR_RESULT(CCLIES_ERROR_REQUEST_DESTINATION_PROBLEM, 0xC0F30001)
CCLIES_ERROR_RESULT(CCLIES_ERROR_TRANSIENT1_ALREADY_REGISTERED, 0xC0F30002)
CCLIES_ERROR_RESULT(CCLIES_ERROR_TRANSIENT1_NOT_REGISTERED, 0xC0F30003)
CCLIES_ERROR_RESULT(CCLIES_ERROR_TRANSIENT2_ALREADY_REGISTERED, 0xC0F30004)
CCLIES_ERROR_RESULT(CCLIES_ERROR_TRANSIENT2_NOT_REGISTERED, 0xC0F30005)
CCLIES_ERROR_RESULT(CCLIES_ERROR_SLMP_ALREADY_REGISTERED, 0xC0F30006)
CCLIES_ERROR_RESULT(CCLIES_ERROR_SLMP_NOT_REGISTERED, 0xC0F30007)
CCLIES_ERROR_RESULT(CCLIES_ERROR_SLMP_INVALID_TYPE_PARAMETER, 0xC0F30008)
CCLIES_ERROR_RESULT(CCLIES_ERROR_CONFIGURATION_BUSY, 0xC0F30009)
CCLIES_ERROR_RESULT(CCLIES_ERROR_INVALID_DEVICE_TYPE, 0xC0F3000A)
CCLIES_ERROR_RESULT(CCLIES_ERROR_INVALID_MAX_RX_BYTES, 0xC0F3000B)
CCLIES_ERROR_RESULT(CCLIES_ERROR_INVALID_MAX_RY_BYTES, 0xC0F3000C)
CCLIES_ERROR_RESULT(CCLIES_ERROR_INVALID_MAX_RWR_POINTS, 0xC0F3000D)
CCLIES_ERROR_RESULT(CCLIES_ERROR_INVALID_MAX_RWW_POINTS, 0xC0F3000E)
CCLIES_ERROR_RESULT(CCLIES_ERROR_INVALID_MIN_RX_BYTES, 0xC0F3000F)
CCLIES_ERROR_RESULT(CCLIES_ERROR_INVALID_MIN_RY_BYTES, 0xC0F30010)
CCLIES_ERROR_RESULT(CCLIES_ERROR_INVALID_MIN_RWR_POINTS, 0xC0F30011)
CCLIES_ERROR_RESULT(CCLIES_ERROR_INVALID_MIN_RWW_POINTS, 0xC0F30012)
CCLIES_ERROR_RESULT(CCLIES_ERROR_INVALID_IOTYPE, 0xC0F30013)
CCLIES_ERROR_RESULT(CCLIES_ERROR_INVALID_NET_NUMBER, 0xC0F30014)
CCLIES_ERROR_RESULT(CCLIES_ERROR_CYCLIC_STOPPED, 0xC0F30015)
CCLIES_ERROR_RESULT(CCLIES_ERROR_ERROR_BLINK, 0xC0F30016)
CCLIES_ERROR_RESULT(CCLIES_ERROR_INVALID_STATION_NUMBER, 0xC0F30017)

CCLIES_ERROR_RESULT(CCLIES_ERROR_LLD_INVALID_FIRMWARE, 0xC0F3F000)
CCLIES_ERROR_RESULT(CCLIES_ERROR_LLD_NOT_READY_COOKIE, 0xC0F3F001)
CCLIES_ERROR_RESULT(CCLIES_ERROR_LLD_NOT_READY_STATUS, 0xC0F3F002)
CCLIES_ERROR_RESULT(CCLIES_ERROR_LLD_INVALID_PARAMETER, 0xC0F3F003)
CCLIES_ERROR_RESULT(CCLIES_ERROR_LLD_UNKNOWN_ERROR, 0xC0F3F004)
CCLIES_ERROR_RESULT(CCLIES_ERROR_LLD_OUT_OF_MEMORY, 0xC0F3F005)
CCLIES_ERROR_RESULT(CCLIES_ERROR_LLD_IRQ_INIT_ERROR, 0xC0F3F006)
CCLIES_ERROR_RESULT(CCLIES_ERROR_LLD_BUSY, 0xC0F3F007)

/* HIL_COMPONENT_ID_CCLIES_IF             =  0xF4:HIL_COMPONENT_ID_CCLIES_IF */
/* HIL_COMPONENT_ID_CCLIES_AP             =  0xF5:HIL_COMPONENT_ID_CCLIES_AP */
/* HIL_COMPONENT_ID_SLMP_ENDCODE          =  0xF6:HIL_COMPONENT_ID_SLMP_ENDCODE */
CCLIES_ERROR_RESULT(CCLIES_ERROR_SLMP_ENDCODE_MAPPING_START, 0xC0F60001)
CCLIES_ERROR_RESULT(CCLIES_ERROR_SLMP_ENDCODE_CMD_SUBCMD_ERROR, 0xC0F6C059)
CCLIES_ERROR_RESULT(CCLIES_ERROR_SLMP_ENDCODE_CMD_ERROR_IN_REQ_MESSAGE, 0xC0F6C05C)
CCLIES_ERROR_RESULT(CCLIES_ERROR_SLMP_ENDCODE_CMD_REQ_LENGTH_DOES_NOT_MATCH, 0xC0F6C061)
CCLIES_ERROR_RESULT(CCLIES_ERROR_SLMP_ENDCODE_BUSY, 0xC0F6CEE0)
CCLIES_ERROR_RESULT(CCLIES_ERROR_SLMP_ENDCODE_REQUEST_SIZE_EXCEEDED_EFFECTIVE_PROCESSING_RANGE, 0xC0F6CEE1)
CCLIES_ERROR_RESULT(CCLIES_ERROR_SLMP_ENDCODE_RESPONSE_SIZE_EXCEEDED_EFFECTIVE_PROCESSING_RANGE, 0xC0F6CEE2)
CCLIES_ERROR_RESULT(CCLIES_ERROR_SLMP_ENDCODE_SPECIFIED_SERVER_INFO_NUMBER_DOES_NOT_EXIST, 0xC0F6CF10)
CCLIES_ERROR_RESULT(CCLIES_ERROR_SLMP_ENDCODE_CONTAINED_ITEMS_CANNOT_BE_SET, 0xC0F6CF20)
CCLIES_ERROR_RESULT(CCLIES_ERROR_SLMP_ENDCODE_PARAMETER_ID_DOES_NOT_EXIST, 0xC0F6CF30)
CCLIES_ERROR_RESULT(CCLIES_ERROR_SLMP_ENDCODE_WRITE_EXCLUSIVE_START_NOT_PERFORMED, 0xC0F6CF31)
CCLIES_ERROR_RESULT(CCLIES_ERROR_SLMP_ENDCODE_RELAY_PATH_DESTINATION_COMM_ERROR, 0xC0F6CF70)
CCLIES_ERROR_RESULT(CCLIES_ERROR_SLMP_ENDCODE_TIMEOUT_OCCURED, 0xC0F6CF71)
CCLIES_ERROR_RESULT(CCLIES_ERROR_SLMP_ENDCODE_MAPPING_END, 0xC0F6FFFF)

/* HIL_COMPONENT_ID_CCL_TRANSIENT         =  0xF7:HIL_COMPONENT_ID_CCL_TRANSIENT */

CCLIES_ERROR_TABLE_END

#endif
